/*
 * Copyright (c) Doug Palmer <doug@charvolant.org> 2005
 *
 * See LICENSE for licensing details.
 * 
 * $Id$
 */

package org.charvolant.sudoku;

/**
 * The trailing of the elimination of a possibility.
 * 
 * @author doug
 *
 */
public class TrailEliminate extends TrailEntry {
  /** The value that was eliminated */
  private int value;
  
  /**
   * Construct for a cell and a value.
   * 
   * @param cell The cell being trailed
   * @param value The value that was eliminated
   */
  public TrailEliminate(Cell cell, int value) {
    super(cell);
    this.value = value;
  }
  
  /**
   * Get the trailed value.
   *
   * @return Returns the value.
   */
  public int getValue() {
    return this.value;
  }

  /**
   * Rewind the trail entry.
   */
  @Override
  public void rewind() {
    this.cell.rewind(this);
  }

}
